package gov.va.med.mhv.vitals.service;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.vitals.dto.BloodPressureReadingDTO;
import gov.va.med.mhv.vitals.dto.BloodSugarReadingDTO;
import gov.va.med.mhv.vitals.dto.BodyTemperatureDTO;
import gov.va.med.mhv.vitals.dto.BodyWeightReadingDTO;
import gov.va.med.mhv.vitals.dto.HeartRateReadingDTO;
import gov.va.med.mhv.vitals.dto.InrReadingDTO;
import gov.va.med.mhv.vitals.dto.LipidsReadingDTO;
import gov.va.med.mhv.vitals.dto.PainReadingDTO;
import gov.va.med.mhv.vitals.dto.PulseOximetryReadingDTO;
import gov.va.med.mhv.vitals.dto.VitalSignsSummaryDTO;

@Service("vitalSignsService")
@Path("/")
public interface VitalSignsService {
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("summary/{userProfileId}")
	VitalSignsSummaryDTO getVitalSignsSummary(@PathParam("userProfileId")Long userProfileId) throws MHVException;
	
	// Blood Pressure
	
	@POST
	@Path("/bloodpressure")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	Long saveBloodPressureReading(BloodPressureReadingDTO bpDTO) throws MHVException;
	
	@DELETE
	@Path("/bloodpressure/{userProfileId}/{id}")
	void deleteBloodPressureReading(@PathParam("userProfileId")Long userProfileId, @PathParam("id")Long id) throws MHVException;
	
	@GET
	@Path("/bloodpressure/{userProfileId}")
	@Produces(MediaType.APPLICATION_JSON)
	List<BloodPressureReadingDTO> getBloodPressureReadingsForUser(@PathParam("userProfileId")Long userProfileId) throws MHVException;
	
	@GET
	@Path("/bloodpressure/{userProfileId}/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	BloodPressureReadingDTO getBloodPressureReadingById(@PathParam("userProfileId")Long userProfileId, @PathParam("id")Long id) throws MHVException;
	
	// Blood Sugar
	@POST
	@Path("/bloodsugar")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	Long saveBloodSugarReading(BloodSugarReadingDTO bloodSugarDTO) throws MHVException;
	
	@DELETE
	@Path("/bloodsugar/{userProfileId}/{id}")
	void deleteBloodSugarReading(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	@GET
	@Path("/bloodsugar/{userProfileId}")
	@Produces(MediaType.APPLICATION_JSON)
	List<BloodSugarReadingDTO> getBloodSugarReadingsForUser(@PathParam("userProfileId")Long userProfileId) throws MHVException;
	
	@GET
	@Path("/bloodsugar/{userProfileId}/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	BloodSugarReadingDTO getBloodSugarReadingBy(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	// Body Temperature
	@POST
	@Path("/bodytemperature")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	Long saveBodyTemperatureReading(BodyTemperatureDTO bodyTemperatureDTO) throws MHVException;
	
	@DELETE
	@Path("/bodytemperature/{userProfileId}/{id}")
	void deleteBodyTemperatureReading(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	@GET
	@Path("/bodytemperature/{userProfileId}")
	@Produces(MediaType.APPLICATION_JSON)
	List<BodyTemperatureDTO> getTemperatureReadingsForUser(@PathParam("userProfileId")Long userProfileId) throws MHVException;
	
	@GET
	@Path("/bodytemperature/{userProfileId}/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	BodyTemperatureDTO getTemperatureReadingByid(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	// Body Weight
	@POST
	@Path("/bodyweight")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	Long saveBodyWeightReading(BodyWeightReadingDTO bwDTO) throws MHVException;
	
	@DELETE
	@Path("/bodyweight/{userProfileId}/{id}")
	void deleteBodyWeightReading(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	@GET
	@Path("/bodyweight/{userProfileId}")
	@Produces(MediaType.APPLICATION_JSON)
	List<BodyWeightReadingDTO> getBWReadingsForUser(@PathParam("userProfileId")Long userProfileId) throws MHVException;
	
	@GET
	@Path("/bodyweight/{userProfileId}/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	BodyWeightReadingDTO getBWReadingByid(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	// Heart Rate
	@POST
	@Path("/heartrate")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	Long saveHeartRateReading(HeartRateReadingDTO heartRateDTO) throws MHVException;
	
	@DELETE
	@Path("/heartrate/{userProfileId}/{id}")
	void deleteHeartRateReading(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	@GET
	@Path("/heartrate/{userProfileId}")
	@Produces(MediaType.APPLICATION_JSON)
	List<HeartRateReadingDTO> getHeartRateReadingsForUser(@PathParam("userProfileId")Long userProfileId) throws MHVException;
	
	@GET
	@Path("/heartrate/{userProfileId}/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	HeartRateReadingDTO getHeartRateReadingByid(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	// INR
	@POST
	@Path("/inr")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	Long saveInrReading(InrReadingDTO inrDTO) throws MHVException;
	
	@DELETE
	@Path("/inr/{userProfileId}/{id}")
	void deleteInrReading(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	@GET
	@Path("/inr/{userProfileId}")
	@Produces(MediaType.APPLICATION_JSON)
	List<InrReadingDTO> getInrReadingsForUser(@PathParam("userProfileId")Long userProfileId) throws MHVException;
	
	@GET
	@Path("/inr/{userProfileId}/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	InrReadingDTO getINRReadingByid(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	// Lipids
	@POST
	@Path("/lipids")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	Long saveLipidsReading(LipidsReadingDTO lipidDTO) throws MHVException;
	
	@DELETE
	@Path("/lipids/{userProfileId}/{id}")
	void deleteLipidsReading(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	@GET
	@Path("/lipids/{userProfileId}")
	@Produces(MediaType.APPLICATION_JSON)
	List<LipidsReadingDTO> getLipidReadingsForUser(@PathParam("userProfileId")Long userProfileId) throws MHVException;
	
	@GET
	@Path("/lipids/{userProfileId}/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	LipidsReadingDTO getLipidReadingByid(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	// Pain
	@POST
	@Path("/pain")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	Long savePainReading(PainReadingDTO painDTO) throws MHVException;
	
	@DELETE
	@Path("/pain/{userProfileId}/{id}")
	void deletePainReading(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	@GET
	@Path("/pain/{userProfileId}")
	@Produces(MediaType.APPLICATION_JSON)
	List<PainReadingDTO> getPainReadingsForUser(@PathParam("userProfileId")Long userProfileId) throws MHVException;
	
	@GET
	@Path("/pain/{userProfileId}/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	PainReadingDTO getPainReadingByid(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;

	// Pulse Oximetry
	
	@POST
	@Path("/pulseOximetry")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	public Long savePulseOximetryReading(PulseOximetryReadingDTO pulseOximetryDTO) throws MHVException;
	
	@DELETE
	@Path("/pulseOximetry/{userProfileId}/{id}")
	public void deletePulseOximetryReading(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;
	
	@GET
	@Path("/pulseOximetry/{userProfileId}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<PulseOximetryReadingDTO> getPulseOximetryReadingsForUser(@PathParam("userProfileId")Long userProfileId) throws MHVException;
	
	@GET
	@Path("/pulseOximetry/{userProfileId}/{id}")
	@Produces(MediaType.APPLICATION_JSON)
	public PulseOximetryReadingDTO getPulseOximetryReadingByid(@PathParam("userProfileId")Long userProfileId,  @PathParam("id")Long id) throws MHVException;

}
